// Title: Tigra Tree
// Description: See the demo at url
// URL: http://www.softcomplex.com/products/tigra_menu_tree/
// Version: 1.1
// Date: 11-12-2002 (mm-dd-yyyy)
// Notes: This script is free. Visit official site for further details.
var	TREE_ITEMS = [
/*  	['收藏夹', {favId: '56', type: 'folder'},
  		['学习网站', {favId: '12', type: 'folder'}],
  		['我喜欢的网站', {favId: '12', type: 'folder'}],
  		['频道', {favId: '12', type: 'folder'}],
  		['软件更新', {favId: '12', type: 'folder'}],
  		['搜索引擎', {favId: '12', type: 'folder'},
  			['电影', {favId: '12', type: 'folder'}],
  			['音乐', {favId: '12', type: 'folder'},
  				['莫文蔚', {favId: '12', type: 'folder'}],
  				['梁静茹', {favId: '12', type: 'item', url: 'http://www.baidu.com'}],
  			],
  			['小说', {favId: '12', type: 'folder'}],
  			['游戏', {favId: '12', type: 'folder'}],
  		],
  		['腾讯', {favId: '13', type: 'item', url: 'http://www.qq.com'}],		
  	],*/
];

var TREE_TPL = {
	'target'  : 'frameset',	// name of the frame links will be opened in
							// other possible values are: _blank, _parent, _search, _self and _top

	'icon_e'  : 'images/icons/empty.gif', // empty image
	'icon_l'  : 'images/icons/line.gif',  // vertical line

    'icon_32' : 'images/icons/folder.gif',   // root leaf icon normal
    'icon_36' : 'images/icons/folder.gif',   // root leaf icon selected
	
	'icon_48' : 'images/icons/folder.gif',   // root icon normal
	'icon_52' : 'images/icons/folder.gif',   // root icon selected
	'icon_56' : 'images/icons/folder.gif',   // root icon opened
	'icon_60' : 'images/icons/folder.gif',   // root icon selected
	
	'icon_16' : 'images/icons/folder.gif', // node icon normal
	'icon_20' : 'images/icons/folderopen.gif', // node icon selected
	'icon_24' : 'images/icons/folderopen.gif', // node icon opened
	'icon_28' : 'images/icons/folderopen.gif', // node icon selected opened

	'icon_0'  : 'images/icons/page.gif', // leaf icon normal
	'icon_4'  : 'images/icons/page.gif', // leaf icon selected
	
	'icon_2'  : 'images/icons/joinbottom.gif', // junction for leaf
	'icon_3'  : 'images/icons/join.gif',       // junction for last leaf
	'icon_18' : 'images/icons/joinbottom.gif', // junction for closed node
//		'icon_18' : 'images/icons/join.gif', // junction for closed node
	'icon_19' : 'images/icons/join.gif',       // junctioin for last closed node
	'icon_26' : 'images/icons/minusbottom.gif',// junction for opened node
	'icon_27' : 'images/icons/minus.gif',       // junctioin for last opended node
	
	'icon_80': 'images/icons/folder.gif',       // junctioin for last opended node	
	'icon_82': 'images/icons/plusbottom.gif',       // junctioin for last opended node	
	'icon_83': 'images/icons/plus.gif',       // junctioin for last opended node	
	'icon_84': 'images/icons/folderopen.gif',       // junctioin for last opended node	
	'icon_88': 'images/icons/folderopen.gif',       // junctioin for last opended node	
	'icon_90': 'images/icons/plusbottom.gif',       // junctioin for last opended node	
	'icon_91': 'images/icons/plus.gif',       // junctioin for last opended node	
	'icon_92': 'images/icons/folderopen.gif',       // junctioin for last opended node	
	'icon_116': 'images/icons/folder.gif',       // junctioin for last opended node
	'icon_120': 'images/icons/folder.gif',       // junctioin for last opended node	
	'icon_124': 'images/icons/folder.gif'       // junctioin for last opended node	
//		'icon_92': 'images/icons/folderopen.gif'       // junctioin for last opended node	
};

function tree (a_items, a_template, root_id) {

	this.a_tpl      = a_template;
	this.a_config   = a_items;
	this.o_root     = this;
	this.a_index    = [];
	this.o_selected = null;
	this.n_depth    = -1;
	
	var o_icone = new Image(),
		o_iconl = new Image();
	o_icone.src = a_template['icon_e'];
	o_iconl.src = a_template['icon_l'];
	a_template['im_e'] = o_icone;
	a_template['im_l'] = o_iconl;
	for (var i = 0; i < 64; i++)
		if (a_template['icon_' + i]) {
			var o_icon = new Image();
			a_template['im_' + i] = o_icon;
			o_icon.src = a_template['icon_' + i];
		}
	
	this.toggle = function (n_id) {	var o_item = this.a_index[n_id]; o_item.open(o_item.b_opened) };
	this.select = function (n_id) { return this.a_index[n_id].select(); };
	this.mout   = function (n_id) { this.a_index[n_id].upstatus(true) };
	this.mover  = function (n_id) { this.a_index[n_id].upstatus() };

	this.a_children = [];
	for (var i = 0; i < a_items.length; i++)
		new tree_item(this, i);

	this.n_id = trees.length;
	trees[this.n_id] = this;
	
	for (var i = 0; i < this.a_children.length; i++) {
		document.getElementById(root_id).innerHTML = this.a_children[i].init();
		this.a_children[i].open();
	}
	
	// 选中第一项
	trees[0].select(0);
}
function tree_item (o_parent, n_order) {

	this.n_depth  = o_parent.n_depth + 1;
	this.a_config = o_parent.a_config[n_order + (this.n_depth ? 2 : 0)];
	if (!this.a_config) return;

	this.o_root    = o_parent.o_root;
	this.o_parent  = o_parent;
	this.n_order   = n_order;
	this.b_opened  = !this.n_depth;

	this.n_id = this.o_root.a_index.length;
	this.o_root.a_index[this.n_id] = this;
	o_parent.a_children[n_order] = this;

	this.a_children = [];
	for (var i = 0; i < this.a_config.length - 2; i++)
		new tree_item(this, i);

	this.get_icon = item_get_icon;
	this.open     = item_open;
	this.select   = item_select;
	this.init     = item_init;
	this.upstatus = item_upstatus;
	this.is_last  = function () { return this.n_order == this.o_parent.a_children.length - 1 };
}

function item_open (b_close) {
	var o_idiv = get_element('i_div' + this.o_root.n_id + '_' + this.n_id);
	if (!o_idiv) return;
	
	if (!o_idiv.innerHTML) {
		var a_children = [];
		for (var i = 0; i < this.a_children.length; i++)
			a_children[i]= this.a_children[i].init();
		o_idiv.innerHTML = a_children.join('');
	}
	o_idiv.style.display = (b_close ? 'none' : 'block');
	
	this.b_opened = !b_close;
	var o_jicon = document.images['j_img' + this.o_root.n_id + '_' + this.n_id],
		o_iicon = document.images['i_img' + this.o_root.n_id + '_' + this.n_id];
	if (o_jicon) o_jicon.src = this.get_icon(true);
	if (o_iicon) o_iicon.src = this.get_icon();
	this.upstatus();
}

function item_select (b_deselect) {
	if (!b_deselect) {
		var o_olditem = this.o_root.o_selected;
		this.o_root.o_selected = this;
		if (o_olditem) o_olditem.select(true);
	}
	var o_iicon = document.images['i_img' + this.o_root.n_id + '_' + this.n_id];
	if (o_iicon) o_iicon.src = this.get_icon();
	
	get_element('i_txt' + this.o_root.n_id + '_' + this.n_id).firstChild.nextSibling.className = b_deselect ? '' : 'selected';
	
	this.upstatus();
	return Boolean(this.a_config[1]);
}

function item_upstatus (b_clear) {
	window.setTimeout('window.status="' + (b_clear ? '' : this.a_config[0] + (this.a_config[1] ? ' ('+ this.a_config[1] + ')' : '')) + '"', 10);
}

function item_init () {
	var a_offset = [],
		o_current_item = this.o_parent;
	for (var i = this.n_depth; i > 1; i--) {
		a_offset[i] = '<img src="' + this.o_root.a_tpl[o_current_item.is_last() ? 'icon_e' : 'icon_l'] + '" border="0" align="absbottom">';
		o_current_item = o_current_item.o_parent;
	}
	if(this.a_config[1].type == 'folder') 
		this.a_config[1].url = '';
	
	return '<table cellpadding="0" cellspacing="0" border="0"><tr><td nowrap>' + 
		(this.n_depth 
				? a_offset.join('') 
					+ (this.a_config[1].type == 'folder'
					? '<a href="javascript: trees[' + this.o_root.n_id + '].toggle(' + this.n_id + ')" onmouseover="trees[' + this.o_root.n_id + '].mover(' + this.n_id + ')" onmouseout="trees[' + this.o_root.n_id + '].mout(' + this.n_id + ')"><img src="' + this.get_icon(true) + '" border="0" align="absbottom" name="j_img' + this.o_root.n_id + '_' + this.n_id + '"></a>'
					: '<img src="' + this.get_icon(true) + '" border="0" align="absbottom">') 
				: ''
		) 
		+ '<a href="javascript:void(0)" url="' + this.a_config[1].url + '" favId="' + this.a_config[1].favId + '" target="' + this.o_root.a_tpl['target'] + '" onclick="fillInput(this);return trees[' + this.o_root.n_id + '].select(' + this.n_id + ');" ondblclick="trees[' + this.o_root.n_id + '].toggle(' + this.n_id + ')" onmouseover="trees[' + this.o_root.n_id + '].mover(' + this.n_id + ')" onmouseout="trees[' + this.o_root.n_id + '].mout(' + this.n_id + ')" class="t' + this.o_root.n_id + 'i" id="i_txt' + this.o_root.n_id + '_' + this.n_id + '"><img src="' + this.get_icon() + '" border="0" align="absbottom" name="i_img' + this.o_root.n_id + '_' + this.n_id + '" class="t' + this.o_root.n_id + 'im">' + '<span>' + this.a_config[0] + '</span>' + '</a></td></tr></table>' + (this.a_children.length ? '<div id="i_div' + this.o_root.n_id + '_' + this.n_id + '" style="display:none"></div>' : '');
}

function item_get_icon (b_junction) {
	return this.o_root.a_tpl['icon_' + ((this.n_depth ? 0 : 32) 
			+ (this.a_config[1].type == 'folder' ? 16 : 0)
			+ (this.a_config[1].type == 'folder' && this.a_children.length ? 64 : 0)	
			+ (this.a_config[1].type == 'folder' && this.b_opened ? 8 : 0) 
			+ (!b_junction && this.o_root.o_selected == this ? 4 : 0) 
			+ (b_junction ? 2 : 0) + (b_junction && this.is_last() ? 1 : 0))];
}

function fillInput(element) {
	curID = element.getAttribute('favId');
	
	return;
	
	var url = element.getAttribute('url');
	var title = element.getElementsByTagName('span')[0].innerHTML;
	if(url && title) {
		document.getElementById('input-title').value = title;
		document.getElementById('input-url').value = url;
	}
}

var trees = [];
get_element = document.all ?
	function (s_id) { return document.all[s_id] } :
	function (s_id) { return document.getElementById(s_id) };

/**
 * get selectd favId
 * @returns
 * @author sunnyjiang
 */
function get_selected_favId() {
	 var el = document.getElementsByTagName('span'); 
	 
	 for (var i = 0; i < _el.length; i++ ) { 
		 if (_el[i].className.indexOf('selected') > -1) { 
			 return _el[i].parentNode.getAttribute('favId'); 
		 } 
	 } 
}